# Lesson 3: The "Done" Framework

The quality of your output is directly proportional to the quality of your input.

People who get terrible results are the ones who type "organize my files" and expect magic.

Let's fix that.

WAIT: Ever given someone vague instructions and gotten something totally different than you expected?

USER: Yes

---

Before you delegate anything, answer three questions in your prompt:

**1. What does "done" look like?**

If you can't picture the finished state, neither can I.

Here are two ways to ask for the same thing:

**A:** "Create an expense report"

**B:** "Create an Excel spreadsheet with columns for date, vendor, amount, and category, sorted by date, with a sum total at the bottom"

WAIT: Which is more actionable – A or B? And why?

USER: [Explains B is more specific]

Right. B gives me a clear picture of the finished product. A leaves me guessing. Specific = actionable. Vague = guesswork.

---

**2. What context do I need?**

Do I know your naming conventions? Your folder preferences? The difference between work and personal documents?

If you don't tell me, I'll make assumptions. Sometimes they're right. Sometimes they're not.

WAIT: Flip it around – what context would YOU need if someone asked you to organize their files?

USER: [Thinks through what they'd need – naming preferences, categories, what to do with duplicates, etc.]

Those are exactly the kinds of things to include in your delegation.

---

**3. What constraints matter?**

- "Don't delete any files, just move them."
- "Keep the original filenames but add a date prefix."
- "Only process files from the last 90 days."

I can't read your mind about limits you haven't stated.

The safest default: always say "don't delete anything" unless you specifically want deletions.

WAIT: Ready to practice?

USER: Yes

---

Here's a folder with files to organize.

ACTION: Show what's in scenarios/done-framework/ (mix of files that could be organized multiple ways)

This time, give me a delegation that includes:
- What "done" looks like (specific output)
- Any context I need
- Any constraints

WAIT: Write me a detailed delegation for organizing these files.

USER: [Detailed delegation]

---

ACTION: Follow their specific instructions exactly

ACTION: Create summary document

Done – exactly as you specified.

WAIT: What was different about this output compared to Lesson 2?

USER: [Reflects – more control, matched expectations better, got what they actually wanted]

That's the power of the "Done" framework. Same tool, wildly different results based on how you ask.

---

Here are templates you can steal for common tasks:

**File organization:**
"Organize all files in this folder. Group into subfolders by [project/client/type]. Rename using YYYY-MM-DD-description format. Don't delete anything. Create a summary of what you moved."

**Research synthesis:**
"Read all documents in this folder. Create a report synthesizing key findings. Include direct quotes with source filenames. Flag contradictions. End with unanswered questions."

**Data extraction:**
"Extract data from these [receipts/screenshots/forms] into an Excel spreadsheet with columns for [list]. Sort by [column]. Add totals. Flag anything unclear."

I'll use these patterns throughout the course.

WAIT: Ready to tackle a bigger challenge?

USER: Yes

---

**What you learned:** The "Done" framework – define done, give context, set constraints.

**Key insight:** Specific inputs = specific outputs. Vague inputs = guesswork.

**Next up:** Real file organization at scale – the kind that made people lose their minds in demos.

**To continue:** Start a fresh Cowork session and say: *"Read START-HERE.md and start lesson 4"*
